#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27520);
 script_cve_id("CVE-2007-4074");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: festival security update (festival-4377)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch festival-4377.

Description :

The festival daemon runs as root. The default config
doesn't have a password set. A local attacker could
therefore connect to the daemon to have commands executed
as root (CVE-2007-4074).


Solution : 

Install the security patch festival-4377.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the festival-4377 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"festival-1.95-25.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"festival-devel-1.95-25.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"festival-1.96-21", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"festival-devel-1.96-21", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
