#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27216);
 script_cve_id("CVE-2007-2799");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: file: This update fixes a vulnerability in file (file-3757)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch file-3757.

Description :

This update fixes an integer overflow in function
file_printf() of file. This bug can be used to execute
arbitrary code. (CVE-2007-2799)


Solution : 

Install the security patch file-3757.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the file-3757 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"file-4.16-15.13", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"file-32bit-4.16-15.13", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"file-64bit-4.16-15.13", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"file-devel-4.16-15.13", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
