#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29432);
 script_cve_id("CVE-2006-3311", "CVE-2006-4640");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for flash-player (flash-player-2065)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch flash-player-2065.

Description :

Multiple input validation errors have been identified in
Flash Player that could lead to the potential execution of
arbitrary code. These vulnerabilities could be accessed
through content delivered from a remote location via the
user's web browser, email client, or other applications
that include or reference the Flash Player.
(CVE-2006-3311, CVE-2006-3587, CVE-2006-3588)

These updates include changes to prevent circumvention of
the 'allowScriptAccess' option. (CVE-2006-4640)


Solution : 

Install the security patch flash-player-2065.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the flash-player-2065 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"flash-player-7.0.68.0-1.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
