#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27222);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Command injection into foomatic-filters. (foomatic-filters-1436)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch foomatic-filters-1436.

Description :

A Bug in cupsomatic/foomatic-filters that allowed remote 
printer users to execute arbitrary commands as the uid of 
the printer daemon has been fixed (CVE-2004-0801). While 
the same problem was fixed in earlier products, the fix got 
lost during package upgrade of foomatic-filters.


Solution : 

Install the security patch foomatic-filters-1436.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the foomatic-filters-1436 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"foomatic-filters-3.0.2-20.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
