#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29440);
 script_cve_id("CVE-2007-3472", "CVE-2007-3475");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for gd (gd-3895)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gd-3895.

Description :

This update fixes multiple integer overflows in the gd
library. Specially crafted files could leverage them to at
least crash gd based applications (CVE-2007-3472,
CVE-2007-3475, CVE-2007-3476, CVE-2007-3477, CVE-2007-3478).


Solution : 

Install the security patch gd-3895.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gd-3895 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gd-2.0.32-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gd-devel-2.0.32-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gd-2.0.32-23.10", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
