#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27233);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: gdm security update (gdm-2387)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gdm-2387.

Description :

A format string bug in the program 'gdmchooser' could
potentially be
 exploited to execute code under a different
user id.


Solution : 

Install the security patch gdm-2387.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gdm-2387 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gdm-2.16.1-36.2", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
