#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29916);
 script_cve_id("CVE-2006-7195");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Geronimo (geronimo-4864)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch geronimo-4864.

Description :

The file 'implict-objects.jsp' displayed some header values
unfiltered. Attackers could exploit that for cross site
scripting (XSS) attacks (CVE-2006-7195).


Solution : 

Install the security patch geronimo-4864.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the geronimo-4864 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"geronimo-1.0-16.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"geronimo-jetty-servlet-container-1.0-16.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"geronimo-tomcat-servlet-container-1.0-16.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
