#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29445);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for gnome-screensave (gnome-screensaver-4284)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gnome-screensaver-4284.

Description :

Memory corruption made the gnome-screensaver process crash
when the screen was locked, leaving the desktop accessible
to anyone without having to enter a password. This fixes
this memory corruption, as confirmed by internal testing.


Solution : 

Install the security patch gnome-screensaver-4284.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gnome-screensaver-4284 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gnome-screensaver-2.14.0-19.39", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gnome-screensaver-2.14.0-19.39", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
