#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29453);
 script_cve_id("CVE-2007-0010");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for gtk2 (gtk2-2497)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch gtk2-2497.

Description :

A denial of service (crash) condition was fixed in the
image handling routines
 of GTK+. This could be triggered
for instance by viewing HTML emails or
 simiar
(CVE-2007-0010)


Solution : 

Install the security patch gtk2-2497.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the gtk2-2497 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gtk2-2.8.10-39.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gtk2-devel-2.8.10-39.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gtk2-doc-2.8.10-39.22", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gtk2-2.8.10-39.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gtk2-devel-2.8.10-39.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"gtk2-doc-2.8.10-39.22", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
