#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29459);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for heartbeat (heartbeat-1978)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch heartbeat-1978.

Description :

This update fixes both a local and a remote denial of
service attack within heartbeat, as well as numerous other
bugs in the messaging and membership layer, GUI, Cluster
Resource Manager, Local Resource Manager and Resource
Agents.



Solution : 

Install the security patch heartbeat-1978.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the heartbeat-1978 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"heartbeat-2.0.7-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"heartbeat-cmpi-2.0.7-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"heartbeat-ldirectord-2.0.7-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"heartbeat-pils-2.0.7-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"heartbeat-stonith-2.0.7-1.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
