#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27264);
 script_cve_id("CVE-2005-4190");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Cross-Site-Scripting  vulnerability fixed. (horde-1600)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch horde-1600.

Description :

This update of horde fixes some cross-site-scripting
vulnerabilities. (CVE-2005-4190,CVE-2006-2195)


Solution : 

Install the security patch horde-1600.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the horde-1600 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"horde-3.0.9-19.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
