#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27266);
 script_cve_id("CVE-2007-1473");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: horde security update (horde-3089)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch horde-3089.

Description :

This udpate fixes a cross site scripting bug (XSS) in horde
(CVE-2007-1473).


Solution : 

Install the security patch horde-3089.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the horde-3089 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"horde-3.0.9-19.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"horde-3.1.3-22", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
