#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27267);
 script_cve_id("CVE-2007-5208");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: hplip security update (hplip-4516)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch hplip-4516.

Description :

The deamon 'hpssd' could be exploited by users to execute
arbitrary commands as root. hpssd only runs on systems that
have HP all-in-one devices configured. In the default
configuration the problem is not remotely exploitable as
hpssd only listens on local interfaces (CVE-2007-5208).


Solution : 

Install the security patch hplip-4516.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the hplip-4516 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"hplip-1.6.10-25", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"hplip-hpijs-1.6.10-25", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"hplip-2.7.7-37.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"hplip-hpijs-2.7.7-37.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
