#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27268);
 script_cve_id("CVE-2007-5200");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: hugin creates fixed-name file in /tmp (hugin-4518)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch hugin-4518.

Description :

This update of hugin disabled the usage of a temporary
file. (CVE-2007-5200)


Solution : 

Install the security patch hugin-4518.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the hugin-4518 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"hugin-0.6.1-30", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"hugin-0.6.99.4-33.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
