#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29464);
 script_cve_id("CVE-2006-4809", "CVE-2006-4808", "CVE-2006-4807", "CVE-2006-4806");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for imlib2-loaders (imlib2-loaders-2261)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch imlib2-loaders-2261.

Description :

Various security problems have been fixed in the imlib2
image loaders:

CVE-2006-4809: A stack buffer overflow in loader_pnm.c
could be used by attackers to execute code by supplying a
handcrafted PNM image.

CVE-2006-4808: A heap buffer overflow in loader_tga.c could
potentially be used by attackers to execute code by
supplying a handcrafted TGA image.

CVE-2006-4807: A out of bounds memory read in loader_tga.c
could be used to crash the imlib2 using application with a
handcrafted TGA image.

CVE-2006-4806: Various integer overflows in width*height
calculations could lead to heap overflows which could
potentially be used to execute code. Affected here are the
ARGB, PNG, LBM, JPEG and TIFF loaders.

Additionaly loading of TIFF images on 64bit systems now
works.

This obsoletes a previous update, which had broken JPEG
loading.


Solution : 

Install the security patch imlib2-loaders-2261.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the imlib2-loaders-2261 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"imlib2-loaders-1.2.1-17.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
