#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29466);
 script_cve_id("CVE-2007-1841");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ipsec-tools (ipsec-tools-3099)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ipsec-tools-3099.

Description :

A bug in the IKE daemon 'racoon' allowed remote attackers
shut down established tunnels (CVE-2007-1841).


Solution : 

Install the security patch ipsec-tools-3099.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ipsec-tools-3099 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ipsec-tools-0.6.5-10.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
