#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29468);
 script_cve_id("CVE-2006-4790");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for IBM Java (java-1_4_2-ibm-2461)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch java-1_4_2-ibm-2461.

Description :

This update brings IBM Java 1.4.2 to Service Release 7.

It contains several undisclosed security fixes, including
the fix for the RSA attack similar to Mitre CVE ID
CVE-2006-4790.

It also contains timezone updates:
- US daylightsaving time update starting 2007.
- Western Australia daylight savings time introduction in
  December 2006.
- Update to current timezone dataset.


Solution : 

Install the security patch java-1_4_2-ibm-2461.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the java-1_4_2-ibm-2461 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"java-1_4_2-ibm-1.4.2.s4-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-devel-1.4.2.s4-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-jdbc-1.4.2.s4-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_4_2-ibm-plugin-1.4.2.s4-23.10", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
