#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(30248);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: java-1_6_0-sun: Security update to 1.6.0 u4 (java-1_6_0-sun-4945)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch java-1_6_0-sun-4945.

Description :

This security update brings SUN Java 1.6.0 to Update 4. The
security issues fixed are not yset publically known, but it
fixes several ones.

It also contains timezone update 2007k.


Solution : 

Install the security patch java-1_6_0-sun-4945.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the java-1_6_0-sun-4945 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"java-1_6_0-sun-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_6_0-sun-alsa-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_6_0-sun-demo-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_6_0-sun-devel-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_6_0-sun-jdbc-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"java-1_6_0-sun-plugin-1.6.0.u4-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
