#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27281);
 script_cve_id("CVE-2006-5750");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: jboss: Securityupdate to fix potential code execution. (jboss-2309)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch jboss-2309.

Description :

This update fixes a problem in the JBOSS server where it
was possible to potentially execute code if the console
manager was enabled. (CVE-2006-5750)


Solution : 

Install the security patch jboss-2309.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the jboss-2309 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"jboss-3.2.5-22.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
