#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29484);
 script_cve_id("CVE-2006-3626", "CVE-2006-2935", "CVE-2006-2451");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Linux kernel (kernel-1896)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch kernel-1896.

Description :

This kernel update fixes the following security problems:

- CVE-2006-3626: A race condition allows local users to
  gain root privileges by changing the file mode of
  /proc/self/ files in a way that causes those files (for
  instance /proc/self/environ) to become setuid root.
  [#192688]
- CVE-2006-2935: A stackbased buffer overflow in CDROM /
  DVD handling was fixed which could be used by a physical
  local attacker to crash the kernel or execute code within
  kernel context, depending on presence of automatic DVD
  handling in the system. [#190396]
- CVE-2006-2451: Due to an argument validation error in
  prctl(PR_SET_DUMPABLE) a local attacker can easily gain
  administrator (root) privileges. [#186980]

and the following non security bugs:

- Limit the maximum number of LUNs to 16384 [#185164]
- LSI 1030/MPT Fusion driver hang during error recovery --
  Optionally disable QAS [#180100]
- advance buffer pointers in h_copy_rdma() to avoid data
  corruption [#186444]


Solution : 

Install the security patch kernel-1896.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the kernel-1896 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"kernel-bigsmp-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-debug-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-default-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-smp-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-source-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-syms-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-xen-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-xenpae-2.6.16.21-0.15", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-bigsmp-2.6.16.21-0.15", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-default-2.6.16.21-0.15", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-smp-2.6.16.21-0.15", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-source-2.6.16.21-0.15", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"kernel-syms-2.6.16.21-0.15", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
