#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29496);
 script_cve_id("CVE-2006-3083", "CVE-2006-3084");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for krb5-apps-servers and krb5-apps-clients (krb5-apps-servers-1938)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch krb5-apps-servers-1938.

Description :

Various return checks of setuid() and seteuid() calls have
been fixed in kerberos client and server applications.

If these applications are setuid, it might have been
possible for local attackers to gain root access.
(CVE-2006-3083)

We are not affected by the seteuid() problems, tracked by
CVE-2006-3084.


Solution : 

Install the security patch krb5-apps-servers-1938.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the krb5-apps-servers-1938 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"krb5-apps-clients-1.4.3-19.5", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"krb5-apps-servers-1.4.3-19.5", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
