#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27313);
 script_cve_id("CVE-2007-0956");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: krb5: Securityfix for a remote authentication bypass (krb5-apps-servers-3021)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch krb5-apps-servers-3021.

Description :

When using the krb5 telnet daemon it was possible for
remote attackers to override authentication mechanisms and
gain root access to the machine by supplying a special
username. 

This is tracked by the Mitre CVE ID CVE-2007-0956.


Solution : 

Install the security patch krb5-apps-servers-3021.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the krb5-apps-servers-3021 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"krb5-apps-servers-1.4.3-19.10.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"krb5-apps-servers-1.5.1-23.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
