#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27316);
 script_cve_id("CVE-2007-3641", "CVE-2007-3644");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: libarchive: security update (libarchive-3982)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libarchive-3982.

Description :

Specially crafted tar-archives could cause programs based
on libarchive to crash, to run into an enless loop or
potentially to even execute arbitrary code (CVE-2007-3641,
CVE-2007-3644, CVE-2007-3645).


Solution : 

Install the security patch libarchive-3982.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libarchive-3982 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"bsdtar-1.3.1-37.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libarchive-1.3.1-37.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libarchive-devel-1.3.1-37.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
