#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27319);
 script_cve_id("CVE-2007-2645");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: libexif5: Security update to fix denial of service attack (libexif5-3704)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libexif5-3704.

Description :

A denial of service problem (crash) was fixed in the EXIF
Loader of libexif, which could be used to crash the browser
or image viewer when it interprets the EXIF tags in
prepared JPEG files. (CVE-2007-2645)


Solution : 

Install the security patch libexif5-3704.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libexif5-3704 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libexif5-0.5.12-39", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
