#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27324);
 script_cve_id("CVE-2006-4514");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: libgsf security update (libgsf-2364)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libgsf-2364.

Description :

Specially crafted OLE documents enabled attackers to use a
heap buffer overlow for executing code (CVE-2006-4514).


Solution : 

Install the security patch libgsf-2364.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libgsf-2364 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libgsf-1.13.99-13.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libgsf-32bit-1.13.99-13.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libgsf-64bit-1.13.99-13.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
