#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27334);
 script_cve_id("CVE-2006-3459", "CVE-2006-3460", "CVE-2006-3464");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: libtiff: Various remotely exploitable bugs fixed (libtiff-1907)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libtiff-1907.

Description :

This update of libtiff is the result of a source-code audit
done by Tavis Ormandy. It fixes various bugs that can lead
to denial-of-service conditions as well as to remote code
execution while parsing a tiff image. (CVE-2006-3459,
CVE-2006-3460, CVE-2006-3461, CVE-2006-3462, CVE-2006-3463,
CVE-2006-3464, CVE-2006-3465)

Please restart your applications.


Solution : 

Install the security patch libtiff-1907.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libtiff-1907 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libtiff-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libtiff-32bit-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libtiff-64bit-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libtiff-devel-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libtiff-devel-32bit-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libtiff-devel-64bit-3.8.2-5.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
