#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29514);
 script_cve_id("CVE-2007-4029", "CVE-2007-4066");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for libvorbis (libvorbis-4584)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch libvorbis-4584.

Description :

Specially crafted OGG files could crash libvorbis or make
it run into an endless loop (CVE-2007-4029, CVE-2007-4065,
CVE-2007-4066).


Solution : 

Install the security patch libvorbis-4584.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the libvorbis-4584 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"libvorbis-1.1.2-13.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.2-13.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libvorbis-1.1.2-13.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"libvorbis-devel-1.1.2-13.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
