#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27344);
 script_cve_id("CVE-2006-2941", "CVE-2006-3636", "CVE-2006-2191");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Security update for mailman (mailman-2170)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch mailman-2170.

Description :

This update of mailman fixes the following security issues:
- A malicious user could visit a specially crafted URI and
  inject an apparent log message into Mailman's error log
  which might induce an unsuspecting administrator to visit
  a phishing site. This has been blocked. Thanks to Moritz
  Naumann for its discovery.
- Fixed denial of service attack which can be caused by
  some standards-breaking RFC 2231 formatted headers.
  CVE-2006-2941.
- Several cross-site scripting issues have been fixed.
  Thanks to Moritz Naumann for their discovery.
  CVE-2006-3636
- Fixed an unexploitable format string vulnerability.
  Discovery and fix by Karl Chen. Analysis of
  non-exploitability by Martin 'Joey' Schulze. Also thanks
  go to Lionel Elie Mamane. CVE-2006-2191.


Solution : 

Install the security patch mailman-2170.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the mailman-2170 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mailman-2.1.7-15.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
