#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27353);
 script_cve_id("CVE-2006-3242");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: mutt: Security fix for imap buffer overflow (mutt-1701)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch mutt-1701.

Description :

Mutt had a buffer overflow in IMAP namespace parsing code
which may open a possible remote vulnerability
(CVE-2006-3242).


Solution : 

Install the security patch mutt-1701.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the mutt-1701 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mutt-1.5.9i-27.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
