#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27355);
 script_cve_id("CVE-2007-1558");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: mutt: APOP vulnerable to password guessing (mutt-3751)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch mutt-3751.

Description :

This update of mutt fixes a vulnerability in the APOP
implementation that allows an active attacker to guess
three bytes of the password. (CVE-2007-1558)


Solution : 

Install the security patch mutt-3751.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the mutt-3751 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"mutt-1.5.9i-27.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
