#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28356);
 script_cve_id("CVE-2007-5198", "CVE-2007-5623");

 script_version ("$Revision: 1.3 $");

 name["english"] = "SuSE Security Update: fix possible buffer overflows in check_http and check_snmp (nagios-plugins-4621)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch nagios-plugins-4621.

Description :

fix possible buffer overflow during HTTP Location header
parsing in check_http (CVE-2007-5198) fix possible buffer
overflow during snmpget parsing in check_snmp
(CVE-2007-5623)


Solution : 

Install the security patch nagios-plugins-4621.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the nagios-plugins-4621 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"nagios-plugins-1.4.2-16.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-extras-1.4.2-16.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-1.4.5-8", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-extras-1.4.5-8", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-1.4.9-19.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-extras-1.4.9-19.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
