#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29526);
 script_cve_id("CVE-2007-5198", "CVE-2007-5623");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for nagios plugins (nagios-plugins-4624)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch nagios-plugins-4624.

Description :

fix possible buffer overflow during HTTP Location header
parsing in check_http (CVE-2007-5198) fix possible buffer
overflow during snmpget parsing in check_snmp
(CVE-2007-5623)


Solution : 

Install the security patch nagios-plugins-4624.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the nagios-plugins-4624 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"nagios-plugins-1.4.5-16.13", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"nagios-plugins-extras-1.4.5-16.13", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
