#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27360);
 script_cve_id("CVE-2006-2162");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: An integer overflow has been fixed. (nagios-www-1311)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch nagios-www-1311.

Description :

An Integer-Overflow exists within the handling of HTTP 
headers by CGIs. This could lead to arbitrary code 
execution by remote attackers on behalf of the Nagios CGI 
scripts. CVE-2006-2162 has been assigned to this issue.


Solution : 

Install the security patch nagios-www-1311.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the nagios-www-1311 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"nagios-www-1.3-14.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
