#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29527);
 script_cve_id("CVE-2006-1168");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for ncompress (ncompress-1911)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ncompress-1911.

Description :

Lack of bounds checking in the decompression routine could
result in a heap buffer underflow. Attackers could
potentially exploit this to execute arbitrary code by
tricking users into decompressing a specially crafted
archive (CVE-2006-1168).


Solution : 

Install the security patch ncompress-1911.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ncompress-1911 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ncompress-4.2.4-15.5", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
