#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29529);
 script_cve_id("CVE-2007-5195");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Novell GroupWise client (novell-groupwise-gwclient-4494)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch novell-groupwise-gwclient-4494.

Description :

This update fixes a security vulnerability in the GroupWise
system that allows a malicious user to intercept
authentication credentials through a 'man in the middle'
attack. (CVE-2007-5195, CVE-2007-5196)


Solution : 

Install the security patch novell-groupwise-gwclient-4494.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the novell-groupwise-gwclient-4494 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"novell-groupwise-gwclient-7.0.2-20070606", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
