#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29961);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Recommended update for novell-ipsec-tools (novell-ipsec-tools-4656)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch novell-ipsec-tools-4656.

Description :

This update fixes a segfault in the GSSAPI initialization.


Solution : 

Install the security patch novell-ipsec-tools-4656.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the novell-ipsec-tools-4656 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"novell-ipsec-tools-0.6.3-26.19", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
