#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29530);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for novell-lum (novell-lum-2053)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch novell-lum-2053.

Description :

This patch provides fixes for:
- overwriting user surename with cn
- memory leek
- redundant calls to LDAP
- security vulnerability 
- issue with returning partial list for group members if
  buffer size passed to LUM is too small
- issues related to uninitialized structure/variable when
  LUM runs from the 
- cache and then need to go to LDAP to get data
- potential seg fault under heavy load
- issue with intruder count being incremented 4 times on
  one incorrect login
- users are not case sensitive when not using cache only
  mode


Solution : 

Install the security patch novell-lum-2053.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the novell-lum-2053 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"novell-lum-2.2.0.6-2.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
