#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29531);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for LUM (novell-lum-2274)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch novell-lum-2274.

Description :

A security problem was fixed in 'novell-lum', the
eDirectory
 based 'Linux User Management'. Under certain
circumstances
 it was possible to login to the console
without any password.
 (ssh is not affected, since it
rejects empty passwords).


Solution : 

Install the security patch novell-lum-2274.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the novell-lum-2274 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"novell-lum-2.2.0.10-0.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
