#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29534);
 
 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for openCryptoki (openCryptoki-4244)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openCryptoki-4244.

Description :

The openCryptoki crypto framework package has been updated
to fix a incorrect crypto initialisation which leads to
weak IV (initial vectors).


Solution : 

Install the security patch openCryptoki-4244.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openCryptoki-4244 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openCryptoki-2.2.2-24.19", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openCryptoki-32bit-2.2.2-24.19", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openCryptoki-devel-2.2.2-24.19", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
