#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27363);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: openldap2: Fixed evaluation of ACLs (openldap2-1917)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openldap2-1917.

Description :

This fixes a bug in the Access Control Processing that
allowed users with 'selfwrite' access to an attribute to
modify arbitrary values of that attribute, instead of just
allowing them to add/delete their own DN to/from that
attribute.


Solution : 

Install the security patch openldap2-1917.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openldap2-1917 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openldap2-2.3.19-18.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
