#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27365);
 script_cve_id("CVE-2006-4924", "CVE-2006-4925", "CVE-2006-5051", "CVE-2006-5052");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: openssh: Security update for security problems solved in OpenSSH 4.4 (openssh-2183)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch openssh-2183.

Description :

Several security problems were fixed in OpenSSH:

- CVE-2006-4924: A denial of service problem has been fixed
  in OpenSSH which could be used to cause lots of CPU
  consumption on a remote openssh server.
- CVE-2006-4925: If a remote attacker is able to inject
  network traffic this could be used to cause a client
  connection to close.
- CVE-2006-5051: Fixed an unsafe signal hander reported by
  Mark Dowd. The signal handler was vulnerable to a race
  condition that could be exploited to perform a
  pre-authentication denial of service. This vulnerability
  could theoretically lead to pre-authentication remote
  code execution if GSSAPI authentication is enabled, but
  the likelihood of successful exploitation appears remote.
- CVE-2006-5052: Fixed a GSSAPI authentication abort that
  could be used to determine the validity of usernames on
  some platforms.


Solution : 

Install the security patch openssh-2183.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the openssh-2183 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"openssh-4.2p1-18.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"openssh-askpass-4.2p1-18.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
