#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27374);
 script_cve_id("CVE-2006-4339", "CVE-2006-4819");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: opera: Security fix for RSA signature forgery problem (opera-2181)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch opera-2181.

Description :

This update fixes the RSA signature checking problem found
in openssl in the Opera webbrowser (which is statically
linked against openssl). (CVE-2006-4339) A URL tag parsing
heap overflow in Opera could be used to potentially execute
code. (CVE-2006-4819)


Solution : 

Install the security patch opera-2181.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the opera-2181 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"opera-9.02-4.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
