#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31309);
 
 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: Opera 9.26 security update. (opera-5028)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch opera-5028.

Description :

This is a version update for Opera to version 9.26 to fix :
- Fixed an issue where simulated text inputs could trick
  users into uploading arbitrary files, as reported by
  Mozilla.
- Image properties can no longer be used to execute
  scripts, as reported by Max Leonov.
- Fixed an issue where the representation of DOM attribute
  values could allow cross site scripting, as reported by
  Arnaud.lb.


Solution : 

Install the security patch opera-5028.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the opera-5028 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"opera-9.26-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"opera-9.26-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"opera-9.26-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
