#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27379);
 script_cve_id("CVE-2007-2524");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: otrs security update (otrs-3544)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch otrs-3544.

Description :

This update fixes a cross site scripting (XSS)
vulnerability in OTRS (CVE-2007-2524).


Solution : 

Install the security patch otrs-3544.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the otrs-3544 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"otrs-2.0.4-10.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
