#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27381);
 script_cve_id("CVE-2006-5170");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: PasswordPolicyResponse control was handled incorrectly (pam_ldap-2194)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pam_ldap-2194.

Description :

pam_ldap did not return an error conditions correctly when
an LDAP directory server responded with a
PasswordPolicyResponse control response, which caused the
pam_authenticate function to return a success code even if
authentication has failed. (CVE-2006-5170)


Solution : 

Install the security patch pam_ldap-2194.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pam_ldap-2194 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pam_ldap-180-13.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"pam_ldap-32bit-180-13.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"pam_ldap-64bit-180-13.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
