#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27382);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: pam_ssh: Update to fix crash caused when using cron (pam_ssh-3024)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pam_ssh-3024.

Description :

If you are using pam_ssh for authentication, 'cron' would
crash when trying to execute jobs. This update fixes this
problem.


Solution : 

Install the security patch pam_ssh-3024.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pam_ssh-3024 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pam_ssh-1.94-30", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
