#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
if (NASL_LEVEL < 3000 ) exit(0);
if(description)
{
 script_id(27383);
 script_cve_id("CVE-2007-0104");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: pdftohtml: This update fixes a vulnerability which occurs while processing a special PDF file. (pdftohtml-2475)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pdftohtml-2475.

Description :

This update fixes a vulnerability which occurs while
processing a
 special PDF file.
 This bug can lead to a
denial-of-service condition, or a memory
 corruption, or to
arbitrary code execution. (CVE-2007-0104)


Solution : 

Install the security patch pdftohtml-2475.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pdftohtml-2475 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pdftohtml-0.36-145.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
