#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28177);
 script_cve_id("CVE-2007-4352", "CVE-2007-5393");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: pdftohtml security update (pdftohtml-4642)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pdftohtml-4642.

Description :

A buffer overflow in the xpdf code contained in pdftohtml
could be exploited by attackers to potentially execute
arbitrary code (CVE-2007-4352, CVE-2007-5392,
CVE-2007-5393).


Solution : 

Install the security patch pdftohtml-4642.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pdftohtml-4642 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pdftohtml-0.36-145.7", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
