#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27388);
 script_cve_id("CVE-2007-2956");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: pfstools security update (pfstools-4083)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch pfstools-4083.

Description :

A buffer overflow when processing RGBE file could
potentially allow attackers to execute arbitrary code by
tricking the victim into running 'pfsinrgbe' on a specially
crafted file (CVE-2007-2956).


Solution : 

Install the security patch pfstools-4083.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the pfstools-4083 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"pfstools-1.5-47.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
