#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27397);
 script_cve_id("CVE-2007-1325");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: phpMyAdmin: security update (phpMyAdmin-3990)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch phpMyAdmin-3990.

Description :

Multiple bugs in phpMyAdmin could lead to
cross-site-scripting (XSS) attacks, injection of Javascript
code or to crashing the php interpreter.
(CVE-2007-1325,PMASA-2007-1,PMASA-2007-2,PMASA-2007-3,PMASA-
2007-4)


Solution : 

Install the security patch phpMyAdmin-3990.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the phpMyAdmin-3990 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"phpMyAdmin-2.9.1.1-2.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"phpMyAdmin-2.9.1.1-5", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
